//uncompeleted version of pH engine level2
unit pHLevel2;

interface

uses
  Windows;

type
  TURect = record
    Top, Left, Right, Bottom: Cardinal;
  end;

  TUPoint = record
    X, Y: Cardinal;
  end;

  TVector3D = packed record
    X, Y, Z: Single;
  end;
  PVector3D = ^TVector3D;

  TMouseProc = procedure (Par: Byte); stdcall;
  TKbProc = procedure (Key: Word); stdcall;  

  TEvent = procedure (Sender: Cardinal);

  IFast2D = interface
  ['{EA95D6BA-80FE-4220-8536-D57F7C45BEB8}']
    function SetViewport(Value: TPoint): Boolean; stdcall;
    function GetViewport: TPoint; stdcall;
    procedure Enable2D(Value: Boolean); stdcall;
    function IsEnabled: Boolean; stdcall;
    function AddSprite(Name, SrcTex: PChar; PatternSize: TUPoint): Cardinal; stdcall;
    function SetDefBigTexSize(Value: TPoint): Boolean; stdcall;
    function GetDefBigTexSize: TPoint; stdcall;
    function Draw(DrawID, SpriteID: Cardinal; Position: TURect; AnimFlag: Byte = 0;
      Frame: Cardinal = 1; Color: Cardinal = $FF000000; Z: Cardinal = 1; 
      Intrv: Cardinal = 0; EndFrm: Cardinal = 0; AnimLoop: boolean = False;
      PatrnX: Cardinal = 0; PatrnY: Cardinal = 0): Cardinal; stdcall;
    function DelDraw(DrawID: Cardinal): Cardinal; stdcall;
    procedure SetAlphaMode(Value: Cardinal); stdcall;
    function IsAnim(DrawID: Cardinal): Boolean; stdcall;
  end;

  IFileSystem = interface
  ['{AA61038D-56B4-4812-B7E5-1A849032CFFA}']
    function SetBigFile(FileName: PChar; Key: Cardinal = 0; Create: boolean = false): Cardinal; stdcall;
    function GetBigFileSize: Cardinal; stdcall;
    function OpenFile(FileName: PChar; Create: Cardinal = 0): Pointer; stdcall;
    function CloseFile(FileAddr: Pointer): Boolean; stdcall;
    function DeleteFile(FileName: PChar): Boolean; stdcall;
    function SaveFile(FileAddr: Pointer; FileName: PChar; Dst: Cardinal): Boolean;
    function SetFileSize(FileAddr: Pointer; Value: Integer; Relative: boolean = false): Pointer; stdcall;
    function GetFileSize(FileAddr: Pointer): Cardinal; stdcall;
    function GetFileCount(Mode: Cardinal = 0): Cardinal; stdcall;
    function GetPartsCount: Cardinal; stdcall;
    function FileExists(Name: PChar): Byte; stdcall;
    function CreateDir(Name: PChar; Mode: Byte): Byte; stdcall;
    function DeleteDir(Name: PChar; Mode: Byte): Byte; stdcall;    
  end;

  IInp = interface
  ['{79683F30-417C-4FA4-9F81-8EE4B5DC88F8}']
    function IsMButton(But: Byte): boolean; stdcall;
    function IsKeyPressed(Key: Word): boolean; stdcall;
    function SetMouseProc(Proc: Pointer): Boolean; stdcall;
    procedure SetMousePos(Value: TPoint; Bind: Boolean = False); stdcall;
    function SetKbProc(Proc: Pointer): Boolean; stdcall;
    function GetKbProc: Pointer; stdcall;
    function GetMousePos: TPoint; stdcall;
    function GetMouseDelta: TPoint; stdcall;
    function GetMouseProc: Pointer; stdcall;
  end;

  IGui = interface
  ['{A2532331-E96C-4504-841D-68EE87D6D3E6}']
    procedure EventSet(ID: DWORD; EventID: Byte; Value: TEvent); stdcall;
    function EventGet(ID: DWORD; EventID: Byte): TEvent; stdcall;
    function VisibleGet(ID: DWORD): Boolean; stdcall;
    procedure VisibleSet(ID: DWORD; Value: Boolean); stdcall;
    function EnabledGet(ID: DWORD): Boolean; stdcall;
    procedure EnabledSet(ID: DWORD; Value: Boolean); stdcall;
    procedure ActiveSet(Value: Boolean); stdcall;
    function ActiveGet: Boolean; stdcall;
    function ValueGet(ID: DWORD): Word; stdcall;
    procedure ValueSet(ID: DWORD; Value: Word); stdcall;
    function MaxValueGet(ID: DWORD): Word; stdcall;
    procedure MaxValueSet(ID: DWORD; Value: Word); stdcall;
    function Cheked(ID: DWORD): Boolean; stdcall;
    function Add(inControlType: DWORD; Visible, Enabled: Boolean; inPos: TRect;
      inText: PChar = nil; MaxValue: Word = 0; inTexture: Cardinal = 0;
      inFont: Cardinal = 0): Cardinal; stdcall;
    function IsActive(ID: DWORD): Boolean; stdcall;
    procedure Deactivate(ID: DWORD); stdcall;
    function TextGet(ID: DWORD): PChar; stdcall;
    procedure StateSet(ID, State: DWORD; Value: Boolean); stdcall;
    function StateGet(ID, State: DWORD): Boolean; stdcall;
    function TextSet(ID: DWORD; Value: PChar): Boolean; stdcall;
  end;

  ITimer = interface
  ['{BE33FD80-AD7F-49F0-ABE6-32E857BF3A34}']
    function Add(Interval, Counts: Cardinal; Enabled: Boolean; Action: Pointer): Cardinal; stdcall;
    procedure Remove(ID: Cardinal); stdcall;
    procedure IntervalSet(ID, newInt: Cardinal); stdcall;
    function IntervalGet(ID: Cardinal): Cardinal; stdcall;
    procedure CountsSet(ID, Value: Cardinal); stdcall;
    function CountsGet(ID: Cardinal): Cardinal; stdcall;
    procedure ActionSet(ID: Cardinal; Value: Pointer); stdcall;
    function ActionGet(ID: Cardinal): Pointer; stdcall;
    procedure Enable(ID: Cardinal; Value: Boolean); stdcall;
    function Enabled(ID: Cardinal): Boolean; stdcall;
    procedure ModeSet(Value: Cardinal); stdcall;
    function ModeGet: Cardinal; stdcall;
    procedure Process; stdcall;
    procedure Sync; stdcall;
  end;

  ITextOut = interface
  ['{7B7F3F7A-1933-4018-B5D6-A960C10B0DD9}']
    function Draw(ID: Cardinal; Text, Font: PChar; Pos: TRect;
      Color: Cardinal = $FF000000; Size: Cardinal = 10; Format: Cardinal = DT_LEFT or DT_NOCLIP;
      Weight: Cardinal = 400; Italic: Boolean = False): Cardinal; stdcall;
    function DelDraw(ID: Cardinal): Boolean; stdcall;
    function LoadFont(Font: PChar; Color, Size, Weight: Cardinal; Italic: Boolean): Cardinal; stdcall;
    function DrawPreload(ID: Cardinal; Text: PChar; Pos: TRect; Font: Cardinal;
      Format: Cardinal = DT_LEFT or DT_NOCLIP): Cardinal; stdcall;    
  end;

  IScn = interface
  ['{D87FE90E-E4BB-4AA6-8BCE-4E76C9334893}']
    function Add3dModel(FileName: PChar; Draw: Boolean = True): DWORD; overload; stdcall;
    function Add3dModel(ID: DWORD; Draw: Boolean = True): DWORD; overload; stdcall;
    function ParamBind(ID, Idx: DWORD; Addr: Pointer): Boolean; stdcall;
    function ParamFree(ID, Idx: DWORD): Boolean; stdcall;
    function ParamGetPtr(ID, Idx: DWORD): Pointer; stdcall;
    function TransformSet(ID: DWORD; Value: TVector3D; Idx: Byte = 0): Boolean; overload; stdcall;
    function TransformSet(ID: DWORD; Value: PVector3D; Idx: Byte = 0): Boolean; overload; stdcall;
    procedure CamDirectionSet(vLook, vUp: TVector3D); stdcall;
    procedure CamRotateLook(angle: Single); stdcall;
    procedure CamRotateRight(angle: Single); stdcall;
    procedure CamRotateUp(angle: Single); stdcall;
    procedure CamMoveBF(value: Single); stdcall;
    procedure CamMoveLR(value: Single); stdcall;
    procedure CamMoveUD(value: Single); stdcall;
    procedure CamHeightSet(value: Single); stdcall;
    procedure CamPosSet(Value: TVector3D); stdcall;
    procedure CamPojectionSet(zN, zF, FOV: Single); stdcall;        
  end;

  IEngine = interface
  ['{2CB9F84A-B161-4F46-A4A5-F0E7BA6ABEB1}']
    function GetL1: Pointer; stdcall;
    function GetFS: IFileSystem; stdcall;
    function GetGUI: IGui; stdcall;
    function GetTimer: ITimer; stdcall;
    function GetInput: IInp; stdcall;
    function GetF2d: IFast2D; stdcall;
    function GetText: ITextOut; stdcall;
    function GetScene: IScn; stdcall;
    procedure SetProcessProc(Value: Pointer); stdcall;
    function SetProcessInterval(Value: Cardinal): Boolean; stdcall;
    procedure Loop; stdcall;
    function Log(Txt: PChar; Error: Boolean = False): Boolean; stdcall;
    function SetVideoMode(FullScreen: Boolean = True; VSync: Boolean = False;
      RefreshRate: Word = 60; BPP: Word = 32; zBufFmt: Word = 24; Width: Cardinal = 800; Height: Cardinal = 600; FSAA: Cardinal = 0): Cardinal; stdcall;
    function GetMemMng: TMemoryManager; stdcall;
    function GetFPS: Cardinal; stdcall;
    procedure SetDebugFlag(Value: Cardinal); stdcall;
    procedure TurnOff; stdcall;
    function SetTextureFilter(Filter: Cardinal; Stage: Cardinal = 0): Boolean; stdcall;
    procedure SetScreenClearParam(Cleaning: Boolean; Color: Cardinal); stdcall;
    function GetMemTotallAlloc: Cardinal; stdcall;           
  end;

var
  Eng: IEngine;
  Fs: IFileSystem;
  Timer: ITimer;
  Gui: IGui;
  Inp: IInp;
  e2d: IFast2D;
  Txt: ITextOut;
  Scene: IScn;
  EngDLLH: Cardinal;
  OldMM: TMemoryManager;
  LoadEng: function (L1Heap: Word): IEngine; stdcall;
  UnLoadEng: procedure ; stdcall;

  procedure Load(L1Heap: Word);
  procedure UnLoad;
  function UPoint(X, Y: DWORD): TUPoint;
  function URect(Left, Top, Right, Bottom: DWORD): TURect;
  function IntToStr(Int: Integer): String;
  function StrToInt(Str: string): Integer;
  function MakeColor(A, R, G, B: Byte): Cardinal;
  function FloatToStr(X: Single): string;
  function vec3d(x, y, z: Single): TVector3D;

const
//Gui constants
  //Control type
  CT_BUTTON                 = 1;
  CT_CHEKBOX                = 2;
  CT_PROCESSBAR             = 3;
  CT_PANEL                  = 5;
  CT_EDIT                   = 6;
  CT_LISTBOX                = 7;
  CT_LABEL                  = 8;
  CT_SCROLLBAR              = 9;
  //Control state
  CS_ACTIVE                 = 1;
  CS_MOUSE                  = 2;
  CS_LBDOWN                 = 3;
  CS_RBDOWN                 = 4;
  CS_MBDOWN                 = 5;
  CS_VISIBLE                = 6;
  CS_ENABLED                = 7;
  CS_CHEKED                 = 8;
  //State flag
  SF_VISIBLE                = $20;
  SF_ENABLED                = $40;
  EV_MOUSE                  = 0;
  EV_LBDOWN                 = 1;
  EV_RBDOWN                 = 2;
  EV_MBDOWN                 = 3;
  EV_DEACTIVATE             = 4;  
//File system constants
  MODE_FILES_OPENED         = 1;
  MODE_FILES_IN_BIGFILE     = 0;
  TRY_OPEN                  = 0;
  CREATE_IN_BIGFILE         = 1;
  CREATE_IN_WIN_FS          = 2;
  DEL_IN_DF                 = 0;
  DEL_IN_WFS                = 1;
  BF_ERR                    = 0;
  BF_NOT_FOUND              = 1;
  BF_CLOSE_FILES_IN_BF      = 2;
  BF_OK                     = 3;
  FP_NOT_FOUND              = 0;
  FP_BIGFILE                = 1;
  FP_WFS                    = 2;  
//Input constants
  BUT_LEFT                                               = 0;
  BUT_RIGHT                                              = 1;
  BUT_MIDDLE                                             = 2;
  ACT_LBD                                                = 0;
  ACT_LBU                                                = 1;
  ACT_RBD                                                = 2;
  ACT_RBU                                                = 3;
  ACT_MBD                                                = 4;
  ACT_MBU                                                = 5;
  ACT_WHEEL_U                                            = 6;
  ACT_WHEEL_D                                            = 7;
  ACT_MOVE                                               = 8;
//Fast 2d consts
  ALPHA_SRC_TEXTURE                                      = 2;
  ALPHA_SRC_COLOR                                        = 3;
  ANIM_START                                             = 0;
  ANIM_KEEP                                              = 1;
  ANIM_STOP                                              = 2;
  ANIM_RESUME                                            = 3;
  ANIM_STATIC                                            = 4;
//TF - TextureFilter
  TF_TRILINEAR_ANISOTROPIC                               = 0;
  TF_BILINEAR_ANISOTROPIC                                = 1;
  TF_BILINEAR                                            = 2;
  TF_TRILINEAR                                           = 3;
  TF_POINT                                               = 4;
  TF_NONE                                                = 5;
//Timer mode flags
  TMF_DISABLED                              = 0;
  TMF_ENABLED                               = $1;
  TMF_ON_IDLE                               = $2;
  TMF_HI_PRECISION                          = $4;
//Debug flags
  //Error System Flags
  // 31-30 - halt on
  // 29-20 - max errors
  // 19-10 - max warnings
  // 9-3 - reserved
  // 2 - no info strings
  // 1 - handle exceptions
  EF_H_NO                                               = 0;
  EF_H_WRN                                              = $40000000;
  EF_H_ERR                                              = $80000000;
  EF_H_ALL                                              = $C0000000;
  EF_HANDLE_ERRS                                        = $00000001;
  EF_NO_INFO                                            = $00000002;
  EF_DEF                                                = $FFFFFC03;
  EF_DEBUG                                              = $C0000001;
  EF_RELEASE                                            = $80000002;
  EF_NO_HALT                                            = $00000000;
  ALL_STREAMS                                           = DWORD(-1);
//Scene object
  SO_3DMODEL                                                    = 0;
  SO_USER_MESH                                                  = 1;
  SO_LAND                                                       = 2;
  SO_CAMERA                                                     = 3;
//Transform index
  TI_POS                                                        = 0;
  TI_SCALE                                                      = 1;
  TI_ROTATE                                                     = 2;
//Camera type
  CM_LAND                                                       = 0;
  CM_AIR                                                        = 1;    

implementation

function vec3d(x, y, z: Single): TVector3D;
begin
  Result.X := x;
  Result.Y := y;
  Result.Z := z;
end;

function FloatToStr(X: Single): string;
begin
  Str(X:8:3, Result);
end;

function MakeColor(A, R, G, B: Byte): Cardinal;
begin
  Result := (A shl 24) or (R shl 16) or (G shl 8) or B;
end;

function IntToStr(Int: Integer): String;
begin
  Str(Int, Result);
end;

function StrToInt(Str: string): Integer;
var
  Err: Cardinal;
begin
  Val(Str, Result, Err);
  if Err > 0 then Result := 0;
end;

function UPoint(X, Y: DWORD): TUPoint;
begin
  Result.X := X;
  Result.Y := Y;
end;

function URect(Left, Top, Right, Bottom: DWORD): TURect;
begin
  Result.Left := Left;
  Result.Top := Top;
  Result.Right := Right;
  Result.Bottom := Bottom;
end;

procedure Load(L1Heap: Word);
begin
  EngDLLH := LoadLibrary('pHL2.dll');
  @LoadEng := GetProcAddress(EngDLLH, PChar(1));
  @UnLoadEng := GetProcAddress(EngDLLH, PChar(2));
  if @LoadEng = nil then
    MessageBox(0, 'can''t load l2 dll', 'err', MB_ICONERROR)
  else begin
    Eng := LoadEng(L1Heap);
    if Eng = nil then Halt(0);
    //GetMemoryManager(OldMM);
    //SetMemoryManager(Eng.GetMemMng);
    Fs := Eng.GetFS;
    Timer := Eng.GetTimer;
    Gui := Eng.GetGUI;
    Inp := Eng.GetInput;
    e2d := Eng.GetF2d;
    Txt := Eng.GetText;
    Scene := Eng.GetScene;
  end;
end;

procedure UnLoad;
begin
  Scene := nil;
  Inp := nil;
  Fs := nil;
  Timer := nil;
  Gui := nil;
  Eng := nil;
  e2d := nil;
  Txt := nil;
  //SetMemoryManager(OldMM);
  UnLoadEng;
  FreeLibrary(EngDLLH);
end;

end.
